/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.utilities;

import com.alrex.parcool.common.action.impl.HangDown;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WorldUtil {
    public static Vec3 getRunnableWall(LivingEntity entity, double range) {
        double width = entity.m_20205_() / 2.0f;
        double wallX = 0.0;
        double wallZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBox = new AABB(pos.f_82479_ - width, pos.f_82480_, pos.f_82481_ - width, pos.f_82479_ + width, pos.f_82480_ + (double)entity.m_20206_(), pos.f_82481_ + width);
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(range, 0.0, 0.0))) {
            wallX += 1.0;
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(-range, 0.0, 0.0))) {
            wallX -= 1.0;
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(0.0, 0.0, range))) {
            wallZ += 1.0;
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(0.0, 0.0, -range))) {
            wallZ -= 1.0;
        }
        if (wallX == 0.0 && wallZ == 0.0) {
            return null;
        }
        return new Vec3(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vec3 getWall(LivingEntity entity) {
        double range = entity.m_20205_() / 2.0f;
        double width = (double)entity.m_20205_() * 0.5;
        double wallX = 0.0;
        double wallZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBox = new AABB(pos.m_7096_() - width, pos.m_7098_(), pos.m_7094_() - width, pos.m_7096_() + width, pos.m_7098_() + (double)entity.m_20206_(), pos.m_7094_() + width);
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(range, 0.0, 0.0))) {
            wallX += 1.0;
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(-range, 0.0, 0.0))) {
            wallX -= 1.0;
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(0.0, 0.0, range))) {
            wallZ += 1.0;
        }
        if (!entity.f_19853_.m_45772_(baseBox.m_82363_(0.0, 0.0, -range))) {
            wallZ -= 1.0;
        }
        if (wallX == 0.0 && wallZ == 0.0) {
            return null;
        }
        return new Vec3(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vec3 getVaultableStep(LivingEntity entity) {
        double d = (double)entity.m_20205_() * 0.5;
        Level world = entity.f_19853_;
        double distance = entity.m_20205_() / 2.0f;
        double baseLine = Math.min((double)entity.m_20206_() * 0.86, WorldUtil.getWallHeight(entity));
        double stepX = 0.0;
        double stepZ = 0.0;
        Vec3 pos = entity.m_20182_();
        AABB baseBoxBottom = new AABB(pos.f_82479_ - d, pos.f_82480_, pos.f_82481_ - d, pos.f_82479_ + d, pos.f_82480_ + baseLine, pos.f_82481_ + d);
        AABB baseBoxTop = new AABB(pos.f_82479_ - d, pos.f_82480_ + baseLine, pos.f_82481_ - d, pos.f_82479_ + d, pos.f_82480_ + baseLine + (double)entity.m_20206_(), pos.f_82481_ + d);
        if (!world.m_45772_(baseBoxBottom.m_82363_(distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(distance + 1.8, 0.0, 0.0))) {
            stepX += 1.0;
        }
        if (!world.m_45772_(baseBoxBottom.m_82363_(-distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(-(distance + 1.8), 0.0, 0.0))) {
            stepX -= 1.0;
        }
        if (!world.m_45772_(baseBoxBottom.m_82363_(0.0, 0.0, distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, distance + 1.8))) {
            stepZ += 1.0;
        }
        if (!world.m_45772_(baseBoxBottom.m_82363_(0.0, 0.0, -distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, -(distance + 1.8)))) {
            stepZ -= 1.0;
        }
        if (stepX == 0.0 && stepZ == 0.0) {
            return null;
        }
        return new Vec3(stepX, 0.0, stepZ);
    }

    public static double getWallHeight(LivingEntity entity) {
        Vec3 wall = WorldUtil.getWall(entity);
        if (wall == null) {
            return 0.0;
        }
        Level world = entity.f_19853_;
        double accuracy = entity.m_20206_() / 18.0f;
        double d = (double)entity.m_20205_() * 0.5;
        int loopNum = (int)Math.round((double)entity.m_20206_() / accuracy);
        Vec3 pos = entity.m_20182_();
        double x1 = pos.m_7096_() + d + (double)(wall.m_7096_() > 0.0 ? 1 : 0);
        double y1 = pos.m_7098_();
        double z1 = pos.m_7094_() + d + (double)(wall.m_7094_() > 0.0 ? 1 : 0);
        double x2 = pos.m_7096_() - d + (double)(wall.m_7096_() < 0.0 ? -1 : 0);
        double z2 = pos.m_7094_() - d + (double)(wall.m_7094_() < 0.0 ? -1 : 0);
        boolean canReturn = false;
        for (int i = 0; i < loopNum; ++i) {
            AABB box = new AABB(x1, y1 + accuracy * (double)i, z1, x2, y1 + accuracy * (double)(i + 1), z2);
            if (!world.m_45772_(box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return accuracy * (double)i;
        }
        return entity.m_20206_();
    }

    @Nullable
    public static HangDown.BarAxis getHangableBars(LivingEntity entity) {
        double bbWidth = entity.m_20205_() / 4.0f;
        double bbHeight = 0.35;
        AABB bb = new AABB(entity.m_20185_() - bbWidth, entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_() - bbWidth, entity.m_20185_() + bbWidth, entity.m_20186_() + (double)entity.m_20206_() + 0.35, entity.m_20189_() + bbWidth);
        if (entity.f_19853_.m_45772_(bb)) {
            return null;
        }
        BlockPos pos = new BlockPos(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() + 0.4, entity.m_20189_());
        if (!entity.f_19853_.m_46749_(pos)) {
            return null;
        }
        BlockState state = entity.f_19853_.m_8055_(pos);
        Block block = state.m_60734_();
        HangDown.BarAxis axis = null;
        if (block instanceof RotatedPillarBlock) {
            Direction.Axis pillarAxis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            if (state.m_60838_((BlockGetter)entity.f_19853_, pos)) {
                return null;
            }
            switch (pillarAxis) {
                case X: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case Z: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof EndRodBlock) {
            Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            switch (direction) {
                case EAST: 
                case WEST: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof CrossCollisionBlock) {
            int zCount = 0;
            int xCount = 0;
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52309_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52311_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52310_)).booleanValue()) {
                ++xCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52312_)).booleanValue()) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        } else if (block instanceof WallBlock) {
            int zCount = 0;
            int xCount = 0;
            if (state.m_61143_((Property)WallBlock.f_57951_) != WallSide.NONE) {
                ++zCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57952_) != WallSide.NONE) {
                ++zCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57950_) != WallSide.NONE) {
                ++xCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57953_) != WallSide.NONE) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        }
        return axis;
    }

    public static boolean existsDivableSpace(LivingEntity entity) {
        int i;
        Level world = entity.f_19853_;
        Vec3 lookAngle = entity.m_20154_();
        Vec3 center = entity.m_20182_().m_82549_(new Vec3(lookAngle.f_82479_, 0.0, lookAngle.f_82481_).m_82541_().m_82542_(3.0, 0.0, 3.0));
        if (!world.m_46749_(new BlockPos(center))) {
            return false;
        }
        BlockPos centerPos = new BlockPos(center);
        int neededSpaceHeight = 9;
        boolean hasSpace = true;
        for (i = 0; i < 9; ++i) {
            hasSpace = !world.m_8055_(centerPos).m_60767_().m_76334_();
            hasSpace = hasSpace && world.m_46749_(centerPos.m_122024_()) && !world.m_8055_(centerPos.m_122024_()).m_60767_().m_76334_();
            hasSpace = hasSpace && world.m_46749_(centerPos.m_122029_()) && !world.m_8055_(centerPos.m_122029_()).m_60767_().m_76334_();
            hasSpace = hasSpace && world.m_46749_(centerPos.m_122012_()) && !world.m_8055_(centerPos.m_122012_()).m_60767_().m_76334_();
            boolean bl = hasSpace = hasSpace && world.m_46749_(centerPos.m_122019_()) && !world.m_8055_(centerPos.m_122019_()).m_60767_().m_76334_();
            if (!hasSpace) break;
            centerPos = centerPos.m_7495_();
        }
        if (!hasSpace) {
            return false;
        }
        center = entity.m_20182_().m_82549_(new Vec3(lookAngle.f_82479_, 0.0, lookAngle.f_82481_).m_82541_().m_82542_(5.0, 0.0, 5.0));
        centerPos = new BlockPos(center);
        for (i = 0; i < 9; ++i) {
            hasSpace = !world.m_8055_(centerPos).m_60767_().m_76334_();
            hasSpace = hasSpace && world.m_46749_(centerPos.m_122024_()) && !world.m_8055_(centerPos.m_122024_()).m_60767_().m_76334_();
            hasSpace = hasSpace && world.m_46749_(centerPos.m_122029_()) && !world.m_8055_(centerPos.m_122029_()).m_60767_().m_76334_();
            hasSpace = hasSpace && world.m_46749_(centerPos.m_122012_()) && !world.m_8055_(centerPos.m_122012_()).m_60767_().m_76334_();
            boolean bl = hasSpace = hasSpace && world.m_46749_(centerPos.m_122019_()) && !world.m_8055_(centerPos.m_122019_()).m_60767_().m_76334_();
            if (!hasSpace) break;
            centerPos = centerPos.m_7495_();
        }
        return hasSpace;
    }

    @Nullable
    public static Vec3 getGrabbableWall(LivingEntity entity) {
        double d = (double)entity.m_20205_() * 0.5;
        Level world = entity.f_19853_;
        double distance = entity.m_20205_() / 2.0f;
        double baseLine1 = entity.m_20192_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        double baseLine2 = entity.m_20206_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        Vec3 wall1 = WorldUtil.getGrabbableWall(entity, distance, baseLine1);
        if (wall1 != null) {
            return wall1;
        }
        return WorldUtil.getGrabbableWall(entity, distance, baseLine2);
    }

    @Nullable
    private static Vec3 getGrabbableWall(LivingEntity entity, double distance, double baseLine) {
        float slipperiness;
        double d = (double)entity.m_20205_() * 0.49;
        Level world = entity.f_19853_;
        Vec3 pos = entity.m_20182_();
        AABB baseBoxSide = new AABB(pos.f_82479_ - d, pos.f_82480_ + baseLine - (double)(entity.m_20206_() / 6.0f), pos.f_82481_ - d, pos.f_82479_ + d, pos.f_82480_ + baseLine, pos.f_82481_ + d);
        AABB baseBoxTop = new AABB(pos.f_82479_ - d, pos.f_82480_ + baseLine, pos.f_82481_ - d, pos.f_82479_ + d, pos.f_82480_ + (double)entity.m_20206_(), pos.f_82481_ + d);
        int xDirection = 0;
        int zDirection = 0;
        if (!world.m_45772_(baseBoxSide.m_82363_(distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(distance, 0.0, 0.0))) {
            ++xDirection;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(-distance, 0.0, 0.0)) && world.m_45772_(baseBoxTop.m_82363_(-distance, 0.0, 0.0))) {
            --xDirection;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(0.0, 0.0, distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, distance))) {
            ++zDirection;
        }
        if (!world.m_45772_(baseBoxSide.m_82363_(0.0, 0.0, -distance)) && world.m_45772_(baseBoxTop.m_82363_(0.0, 0.0, -distance))) {
            --zDirection;
        }
        if (xDirection == 0 && zDirection == 0) {
            return null;
        }
        if (xDirection != 0 && zDirection != 0) {
            BlockPos blockPos1 = new BlockPos(entity.m_20185_() + (double)xDirection, entity.m_20191_().f_82289_ + baseLine - 0.3, entity.m_20189_());
            BlockPos blockPos2 = new BlockPos(entity.m_20185_(), entity.m_20191_().f_82289_ + baseLine - 0.3, entity.m_20189_() + (double)zDirection);
            if (!entity.f_19853_.m_46749_(blockPos1)) {
                return null;
            }
            if (!entity.f_19853_.m_46749_(blockPos2)) {
                return null;
            }
            slipperiness = Math.min(entity.f_19853_.m_8055_(blockPos1).getFriction((LevelReader)entity.f_19853_, blockPos1, (Entity)entity), entity.f_19853_.m_8055_(blockPos2).getFriction((LevelReader)entity.f_19853_, blockPos2, (Entity)entity));
        } else {
            BlockPos blockPos = new BlockPos(entity.m_20185_() + (double)xDirection, entity.m_20191_().f_82289_ + baseLine - 0.3, entity.m_20189_() + (double)zDirection);
            if (!entity.f_19853_.m_46749_(blockPos)) {
                return null;
            }
            slipperiness = entity.f_19853_.m_8055_(blockPos).getFriction((LevelReader)entity.f_19853_, blockPos, (Entity)entity);
        }
        return (double)slipperiness <= 0.9 ? new Vec3((double)xDirection, 0.0, (double)zDirection) : null;
    }
}

